/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.util;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ps.uil.ras.IUilServiceability;
import com.ibm.ps.uil.util.UilMessageFormat;

class WCLLoggerServiceability
implements IUilServiceability {
    private static final String TRACE_MASKT = "XWCLSRVT";
    private static final String TRACE_MASKF = "XWCLSRVF";
    private static final String TRACE_MASKD = "XWCLSRVD";
    boolean active;
    ThreadLocal workReference = new ThreadLocal();
    private static final String S_ENTRY = ">> ";
    private static final String S_EXIT = "<< ";
    private static final String S_TEXT = "-- ";
    private static final String S_EXC = "** ";
    private static final String S_STACK = "^^ ";
    private static final String S_DATAN = "   @ ";
    private static final String S_DATA1 = "\n   @ ";

    public WCLLoggerServiceability(boolean active) {
        this.setServiceabilityActive(active);
    }

    public synchronized void setServiceabilityActive(boolean active) {
        this.active = active;
    }

    public synchronized boolean isServiceabilityActive() {
        return this.active;
    }

    private StringBuffer formatContext(IUilServiceability.Context context, String prefix) {
        StringBuffer work = this.getWorkArea();
        work.setLength(0);
        work.append(prefix);
        return work;
    }

    private void logMessage(IUilServiceability.Context context, StringBuffer work) {
        this.logMessage(context, work, null);
    }

    private void logMessage(IUilServiceability.Context context, StringBuffer work, Throwable exception) {
        String traceMask;
        int level;
        switch (context.ivType) {
            case 1: {
                level = 1;
            }
            case 2: {
                level = 2;
            }
            case 3: {
                level = 3;
            }
        }
        level = 3;
        String string = level == 1 ? TRACE_MASKT : (traceMask = level == 2 ? TRACE_MASKF : TRACE_MASKD);
        if (level <= 3) {
            Trace.trace(traceMask, work.toString());
            if (exception != null) {
                Trace.trace(traceMask, exception);
            }
        }
    }

    private StringBuffer getWorkArea() {
        StringBuffer work = (StringBuffer)this.workReference.get();
        if (work == null) {
            work = new StringBuffer(300);
            this.workReference.set(work);
        }
        return work;
    }

    public synchronized void text(IUilServiceability.Context context, String text) {
        if (!this.active) {
            return;
        }
        StringBuffer work = this.formatContext(context, S_TEXT);
        work.append(text);
        this.logMessage(context, work);
    }

    public synchronized void text(IUilServiceability.Context context, String text, Object insert1) {
        if (!this.active) {
            return;
        }
        StringBuffer work = this.formatContext(context, S_TEXT);
        work.append(UilMessageFormat.format((String)text, (Object[])new Object[]{insert1}));
        this.logMessage(context, work);
    }

    public synchronized void text(IUilServiceability.Context context, String text, Object insert1, Object insert2) {
        if (!this.active) {
            return;
        }
        StringBuffer work = this.formatContext(context, S_TEXT);
        work.append(UilMessageFormat.format((String)text, (Object[])new Object[]{insert1, insert2}));
        this.logMessage(context, work);
    }

    public synchronized void text(IUilServiceability.Context context, String text, Object[] inserts) {
        if (!this.active) {
            return;
        }
        StringBuffer work = this.formatContext(context, S_TEXT);
        work.append(UilMessageFormat.format((String)text, (Object[])inserts));
        this.logMessage(context, work);
    }

    public synchronized void entry(IUilServiceability.Context context) {
        if (!this.active) {
            return;
        }
        StringBuffer work = this.formatContext(context, S_ENTRY);
        this.logMessage(context, work);
    }

    public synchronized void entry(IUilServiceability.Context context, Object data1) {
        if (!this.active) {
            return;
        }
        StringBuffer work = this.formatContext(context, S_ENTRY);
        work.append(S_DATA1);
        work.append(data1);
        this.logMessage(context, work);
    }

    public synchronized void entry(IUilServiceability.Context context, Object data1, Object data2) {
        if (!this.active) {
            return;
        }
        StringBuffer work = this.formatContext(context, S_ENTRY);
        work.append(S_DATA1);
        work.append(data1);
        work.append(S_DATAN);
        work.append(data2);
        this.logMessage(context, work);
    }

    public synchronized void entry(IUilServiceability.Context context, Object[] data) {
        if (!this.active) {
            return;
        }
        StringBuffer work = this.formatContext(context, S_ENTRY);
        String prefix = S_DATA1;
        for (int i = 0; i < data.length; ++i) {
            work.append(prefix);
            work.append(data[i]);
            prefix = S_DATAN;
        }
        this.logMessage(context, work);
    }

    public synchronized void exit(IUilServiceability.Context context) {
        if (!this.active) {
            return;
        }
        StringBuffer work = this.formatContext(context, S_EXIT);
        this.logMessage(context, work);
    }

    public synchronized void exit(IUilServiceability.Context context, boolean returnValue) {
        if (!this.active) {
            return;
        }
        StringBuffer work = this.formatContext(context, S_EXIT);
        work.append("Returning ");
        work.append(returnValue);
        this.logMessage(context, work);
    }

    public synchronized void exit(IUilServiceability.Context context, long returnValue) {
        if (!this.active) {
            return;
        }
        StringBuffer work = this.formatContext(context, S_EXIT);
        work.append("Returning ");
        work.append(returnValue);
        this.logMessage(context, work);
    }

    public synchronized void exit(IUilServiceability.Context context, double returnValue) {
        if (!this.active) {
            return;
        }
        StringBuffer work = this.formatContext(context, S_EXIT);
        work.append("Returning ");
        work.append(returnValue);
        this.logMessage(context, work);
    }

    public synchronized void exit(IUilServiceability.Context context, Object returnValue) {
        if (!this.active) {
            return;
        }
        StringBuffer work = this.formatContext(context, S_EXIT);
        work.append("Returning ");
        work.append(returnValue);
        this.logMessage(context, work);
    }

    public synchronized void exception(IUilServiceability.Context context, Throwable throwable) {
        if (!this.active) {
            return;
        }
        StringBuffer work = this.formatContext(context, S_EXC);
        this.logMessage(context, work, throwable);
    }

    public synchronized void stackTrace(IUilServiceability.Context context) {
        if (!this.active) {
            return;
        }
        StringBuffer work = this.formatContext(context, S_STACK);
        this.logMessage(context, work, new Exception("Stack trace"));
    }
}

